<?php
/**
 * The style "default" of the Events
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

?>

<div class="sc_events_item">
	<div class="sc_event_thumb"><?php
		$has_thumb = has_post_thumbnail();
		if ($has_thumb) {
			the_post_thumbnail(jack_well_get_thumb_size('tiny'), array('alt' => get_the_title()));
		}
		?>
	</div>

	<div class="sc_event_info">
		<h5 class="sc_events_item_title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php the_title(); ?></a></h5>
		<?php
			// Event's date
			$date = tribe_get_start_date(null, true, 'd F');
			if (empty($date)) $date = get_the_date('d F');
			?><span class="sc_events_item_date"><?php echo esc_html($date); ?></span>	
	</div>

</div>

<?php

if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}

?>