<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

// Page (category, tag, archive, author) title

if ( jack_well_need_page_title() ) {
	jack_well_sc_layouts_showed('title', true);
	jack_well_sc_layouts_showed('postmeta', false);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_left">
						<?php
						// Post meta on the single post
						if ( false && is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
									'components' => jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts')),
									'counters' => jack_well_array_get_keys_by_value(jack_well_get_theme_option('counters')),
									'seo' => jack_well_is_on(jack_well_get_theme_option('seo_snippets'))
									), 'header', 1)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$jack_well_blog_title = jack_well_get_blog_title();
							$jack_well_blog_title_text = $jack_well_blog_title_class = $jack_well_blog_title_link = $jack_well_blog_title_link_text = '';
							if (is_array($jack_well_blog_title)) {
								$jack_well_blog_title_text = $jack_well_blog_title['text'];
								$jack_well_blog_title_class = !empty($jack_well_blog_title['class']) ? ' '.$jack_well_blog_title['class'] : '';
								$jack_well_blog_title_link = !empty($jack_well_blog_title['link']) ? $jack_well_blog_title['link'] : '';
								$jack_well_blog_title_link_text = !empty($jack_well_blog_title['link_text']) ? $jack_well_blog_title['link_text'] : '';
							} else
								$jack_well_blog_title_text = $jack_well_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($jack_well_blog_title_class); ?>"><?php
								$jack_well_top_icon = jack_well_get_category_icon();
								if (!empty($jack_well_top_icon)) {
									$jack_well_attr = jack_well_getimagesize($jack_well_top_icon);
									$alt_title = esc_html__('top-icon', 'jack-well');
									?><img src="<?php echo esc_url($jack_well_top_icon); ?>" alt="<?php echo esc_attr($alt_title); ?>" <?php if (!empty($jack_well_attr[3])) jack_well_show_layout($jack_well_attr[3]);?>><?php
								}
								echo wp_kses_data($jack_well_blog_title_text);
							?></h1>
							<?php
							if (!empty($jack_well_blog_title_link) && !empty($jack_well_blog_title_link_text)) {
								?><a href="<?php echo esc_url($jack_well_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($jack_well_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'jack_well_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>