<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_args = get_query_var('jack_well_logo_args');

// Site logo
$jack_well_logo_type   = isset($jack_well_args['type']) ? $jack_well_args['type'] : '';
$jack_well_logo_image  = jack_well_get_logo_image($jack_well_logo_type);
$jack_well_logo_text   = jack_well_is_on(jack_well_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$jack_well_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($jack_well_logo_image) || !empty($jack_well_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($jack_well_logo_image)) {
			if (empty($jack_well_logo_type) && function_exists('the_custom_logo') && (int) $jack_well_logo_image > 0) {
				the_custom_logo();
			} else {
				$jack_well_attr = jack_well_getimagesize($jack_well_logo_image);
				echo '<img src="'.esc_url($jack_well_logo_image).'" alt="'.esc_attr($jack_well_logo_text).'"'.(!empty($jack_well_attr[3]) ? ' '.wp_kses_data($jack_well_attr[3]) : '').'>';
			}
		} else {
			jack_well_show_layout(jack_well_prepare_macros($jack_well_logo_text), '<span class="logo_text">', '</span>');
			jack_well_show_layout(jack_well_prepare_macros($jack_well_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>