<?php
/* Visual Composer support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('jack_well_vc_theme_setup9')) {
	add_action( 'after_setup_theme', 'jack_well_vc_theme_setup9', 9 );
	function jack_well_vc_theme_setup9() {
		
		add_filter( 'jack_well_filter_merge_styles',		'jack_well_vc_merge_styles' );

		if (jack_well_exists_visual_composer()) {
	
			// Add/Remove params in the standard VC shortcodes
			//-----------------------------------------------------
			add_filter( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG,	'jack_well_vc_add_params_classes', 10, 3 );
			add_filter( 'vc_iconpicker-type-fontawesome',	'jack_well_vc_iconpicker_type_fontawesome' );
			
			// Color scheme
			$scheme = array(
				"param_name" => "scheme",
				"heading" => esc_html__("Color scheme", 'jack-well'),
				"description" => wp_kses_data( __("Select color scheme to decorate this block", 'jack-well') ),
				"group" => esc_html__('Colors', 'jack-well'),
				"admin_label" => true,
				"value" => array_flip(jack_well_get_list_schemes(true)),
				"type" => "dropdown"
			);
			$sc_list = apply_filters('jack_well_filter_add_scheme_in_vc', array('vc_section', 'vc_row', 'vc_row_inner', 'vc_column', 'vc_column_inner', 'vc_column_text'));
			foreach ($sc_list as $sc)
				vc_add_param($sc, $scheme);
		}
		if (is_admin()) {
			add_filter( 'jack_well_filter_tgmpa_required_plugins', 'jack_well_vc_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'jack_well_vc_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('jack_well_filter_tgmpa_required_plugins',	'jack_well_vc_tgmpa_required_plugins');
	function jack_well_vc_tgmpa_required_plugins($list=array()) {
		if (jack_well_storage_isset('required_plugins', 'js_composer')) {
			$path = jack_well_get_file_dir('plugins/js_composer/js_composer.zip');
			if (!empty($path) || jack_well_get_theme_setting('tgmpa_upload')) {
				$list[] = array(
					'name' 		=> jack_well_storage_get_array('required_plugins', 'js_composer'),
					'slug' 		=> 'js_composer',
					'source'	=> !empty($path) ? $path : 'upload://js_composer.zip',
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}

// Check if Visual Composer installed and activated
if ( !function_exists( 'jack_well_exists_visual_composer' ) ) {
	function jack_well_exists_visual_composer() {
		return class_exists('Vc_Manager');
	}
}

// Check if Visual Composer in frontend editor mode
if ( !function_exists( 'jack_well_vc_is_frontend' ) ) {
	function jack_well_vc_is_frontend() {
		return (isset($_GET['vc_editable']) && $_GET['vc_editable']=='true')
			|| (isset($_GET['vc_action']) && $_GET['vc_action']=='vc_inline');
		//return function_exists('vc_is_frontend_editor') && vc_is_frontend_editor();
	}
}
	
// Merge custom styles
if ( !function_exists( 'jack_well_vc_merge_styles' ) ) {
	//Handler of the add_filter('jack_well_filter_merge_styles', 'jack_well_vc_merge_styles');
	function jack_well_vc_merge_styles($list) {
		if (jack_well_exists_visual_composer()) {
			$list[] = 'plugins/js_composer/_js_composer.scss';
		}
		return $list;
	}
}

// Merge responsive styles
if ( !function_exists( 'jack_well_vc_merge_styles_responsive' ) ) {
	//Handler of the add_filter('jack_well_filter_merge_styles_responsive', 'jack_well_vc_merge_styles_responsive');
	function jack_well_vc_merge_styles_responsive($list) {
		if (jack_well_exists_visual_composer()) {
			$list[] = 'plugins/js_composer/_js_composer-responsive.scss';
		}
		return $list;
	}
}



// Shortcodes support
//------------------------------------------------------------------------

// Add params to the standard VC shortcodes
if ( !function_exists( 'jack_well_vc_add_params_classes' ) ) {
	//Handler of the add_filter( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'jack_well_vc_add_params_classes', 10, 3 );
	function jack_well_vc_add_params_classes($classes, $sc, $atts) {
		// Add color scheme
		if (in_array($sc, apply_filters('jack_well_filter_add_scheme_in_vc', array('vc_section', 'vc_row', 'vc_row_inner', 'vc_column', 'vc_column_inner', 'vc_column_text')))) {
			if (!empty($atts['scheme']) && !jack_well_is_inherit($atts['scheme']))
				$classes .= ($classes ? ' ' : '') . 'scheme_' . $atts['scheme'];
		}
		return $classes;
	}
}
	
// Add theme icons to the VC iconpicker list
if ( !function_exists( 'jack_well_vc_iconpicker_type_fontawesome' ) ) {
	//Handler of the add_filter( 'vc_iconpicker-type-fontawesome',	'jack_well_vc_iconpicker_type_fontawesome' );
	function jack_well_vc_iconpicker_type_fontawesome($icons) {
		$list = jack_well_get_list_icons();
		if (!is_array($list) || count($list) == 0) return $icons;
		$rez = array();
		foreach ($list as $icon)
			$rez[] = array($icon => str_replace('icon-', '', $icon));
		return array_merge( $icons, array(esc_html__('Theme Icons', 'jack-well') => $rez) );
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (jack_well_exists_visual_composer()) { require_once JACK_WELL_THEME_DIR . 'plugins/js_composer/js_composer-styles.php'; }
?>