<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

jack_well_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	jack_well_show_layout(get_query_var('blog_archive_start'));

	$jack_well_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$jack_well_sticky_out = jack_well_get_theme_option('sticky_style')=='columns' 
							&& is_array($jack_well_stickies) && count($jack_well_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$jack_well_cat = jack_well_get_theme_option('parent_cat');
	$jack_well_post_type = jack_well_get_theme_option('post_type');
	$jack_well_taxonomy = jack_well_get_post_type_taxonomy($jack_well_post_type);
	$jack_well_show_filters = jack_well_get_theme_option('show_filters');
	$jack_well_tabs = array();
	if (!jack_well_is_off($jack_well_show_filters)) {
		$jack_well_args = array(
			'type'			=> $jack_well_post_type,
			'child_of'		=> $jack_well_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'taxonomy'		=> $jack_well_taxonomy,
			'pad_counts'	=> false
		);
		$jack_well_portfolio_list = get_terms($jack_well_args);
		if (is_array($jack_well_portfolio_list) && count($jack_well_portfolio_list) > 0) {
			$jack_well_tabs[$jack_well_cat] = esc_html__('All', 'jack-well');
			foreach ($jack_well_portfolio_list as $jack_well_term) {
				if (isset($jack_well_term->term_id)) $jack_well_tabs[$jack_well_term->term_id] = $jack_well_term->name;
			}
		}
	}
	if (count($jack_well_tabs) > 0) {
		$jack_well_portfolio_filters_ajax = true;
		$jack_well_portfolio_filters_active = $jack_well_cat;
		$jack_well_portfolio_filters_id = 'portfolio_filters';
		?>
		<div class="portfolio_filters jack_well_tabs jack_well_tabs_ajax">
			<ul class="portfolio_titles jack_well_tabs_titles">
				<?php
				foreach ($jack_well_tabs as $jack_well_id=>$jack_well_title) {
					?><li><a href="<?php echo esc_url(jack_well_get_hash_link(sprintf('#%s_%s_content', $jack_well_portfolio_filters_id, $jack_well_id))); ?>" data-tab="<?php echo esc_attr($jack_well_id); ?>"><?php echo esc_html($jack_well_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$jack_well_ppp = jack_well_get_theme_option('posts_per_page');
			if (jack_well_is_inherit($jack_well_ppp)) $jack_well_ppp = '';
			foreach ($jack_well_tabs as $jack_well_id=>$jack_well_title) {
				$jack_well_portfolio_need_content = $jack_well_id==$jack_well_portfolio_filters_active || !$jack_well_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $jack_well_portfolio_filters_id, $jack_well_id)); ?>"
					class="portfolio_content jack_well_tabs_content"
					data-blog-template="<?php echo esc_attr(jack_well_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(jack_well_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($jack_well_ppp); ?>"
					data-post-type="<?php echo esc_attr($jack_well_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($jack_well_taxonomy); ?>"
					data-cat="<?php echo esc_attr($jack_well_id); ?>"
					data-parent-cat="<?php echo esc_attr($jack_well_cat); ?>"
					data-need-content="<?php echo (false===$jack_well_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($jack_well_portfolio_need_content) 
						jack_well_show_portfolio_posts(array(
							'cat' => $jack_well_id,
							'parent_cat' => $jack_well_cat,
							'taxonomy' => $jack_well_taxonomy,
							'post_type' => $jack_well_post_type,
							'page' => 1,
							'sticky' => $jack_well_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		jack_well_show_portfolio_posts(array(
			'cat' => $jack_well_cat,
			'parent_cat' => $jack_well_cat,
			'taxonomy' => $jack_well_taxonomy,
			'post_type' => $jack_well_post_type,
			'page' => 1,
			'sticky' => $jack_well_sticky_out
			)
		);
	}

	jack_well_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>