<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);
$jack_well_animation = jack_well_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($jack_well_post_format) ); ?>
	<?php echo (!jack_well_is_off($jack_well_animation) ? ' data-animation="'.esc_attr(jack_well_get_animation_classes($jack_well_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Post taxonomies
	$tags = get_the_tag_list( '<span class="post_meta_item post_tags"><span class="post_meta_label">'.'</span> ', ' ', '</span>' );


	// Featured image
	jack_well_show_post_featured(
		array(
			'thumb_size' => jack_well_get_thumb_size( strpos(jack_well_get_theme_option('body_style'), 'full')!==false ? 'full' : 'extra' ),
			'post_info' => !empty($tags) ? '<div class="post_info"><div class="post_tags">'.$tags.'</div></div>' : ''
		)
	);

	?><div class="post_content_outer_wrap"><?php

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php


			do_action('jack_well_action_before_post_meta');

			// Post meta
			$jack_well_components = jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts'));
			$jack_well_counters = jack_well_array_get_keys_by_value(jack_well_get_theme_option('counters'));

			if (!empty($jack_well_components))
				jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
						'components' => $jack_well_components,
						'counters' => $jack_well_counters,
						'seo' => false
					), 'excerpt', 1)
				);


			do_action('jack_well_action_before_post_title');

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );


			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (jack_well_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'jack-well' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'jack-well' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$jack_well_show_learn_more = !in_array($jack_well_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($jack_well_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($jack_well_post_format == 'quote') {
					if (($quote = jack_well_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						jack_well_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 4)!='[vc_') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $jack_well_show_learn_more ) {
				?><p class="more-link-block"><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'jack-well'); ?></a></p><?php

				$author_id = get_the_author_meta('ID');
				if (empty($author_id) && !empty($GLOBALS['post']->post_author))
					$author_id = $GLOBALS['post']->post_author;
				if ($author_id > 0) {
					$author_link = get_author_posts_url($author_id);
					$author_name = get_the_author_meta('display_name', $author_id);
					?>
					<a class="post_meta_item post_author" rel="author" href="<?php echo esc_url($author_link); ?>">
						<?php esc_html_e('by ', 'jack-well')?>
						<?php echo esc_html($author_name); ?>
					</a>
					<?php
				}

			}

		}
	?></div><!-- .entry-content -->
	</div>
</article>