<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.14
 */
$jack_well_header_video = jack_well_get_header_video();
$jack_well_embed_video = '';
if (!empty($jack_well_header_video) && !jack_well_is_from_uploads($jack_well_header_video)) {
	if (jack_well_is_youtube_url($jack_well_header_video) && preg_match('/[=\/]([^=\/]*)$/', $jack_well_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$jack_well_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($jack_well_header_video) . '[/embed]' ));
			$jack_well_embed_video = jack_well_make_video_autoplay($jack_well_embed_video);
		} else {
			$jack_well_header_video = str_replace('/watch?v=', '/embed/', $jack_well_header_video);
			$jack_well_header_video = jack_well_add_to_url($jack_well_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$jack_well_embed_video = '<iframe src="' . esc_url($jack_well_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php jack_well_show_layout($jack_well_embed_video); ?></div><?php
	}
}
?>