<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr(jack_well_get_theme_option('menu_mobile_fullscreen') > 0 ? 'fullscreen' : 'narrow'); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php

		// Logo
		set_query_var('jack_well_logo_args', array('type' => 'mobile'));
		get_template_part( 'templates/header-logo' );
		set_query_var('jack_well_logo_args', array());

		// Mobile menu
		$jack_well_menu_mobile = jack_well_get_nav_menu('menu_mobile');
		if (empty($jack_well_menu_mobile)) {
			$jack_well_menu_mobile = apply_filters('jack_well_filter_get_mobile_menu', '');
			if (empty($jack_well_menu_mobile)) $jack_well_menu_mobile = jack_well_get_nav_menu('menu_main');
			if (empty($jack_well_menu_mobile)) $jack_well_menu_mobile = jack_well_get_nav_menu();
		}
		if (!empty($jack_well_menu_mobile)) {
			if (!empty($jack_well_menu_mobile))
				$jack_well_menu_mobile = str_replace(
					array('menu_main', 'id="menu-', 'sc_layouts_menu_nav', 'sc_layouts_hide_on_mobile', 'hide_on_mobile'),
					array('menu_mobile', 'id="menu_mobile-', '', '', ''),
					$jack_well_menu_mobile
					);
			if (strpos($jack_well_menu_mobile, '<nav ')===false)
				$jack_well_menu_mobile = sprintf('<nav class="menu_mobile_nav_area">%s</nav>', $jack_well_menu_mobile);
			jack_well_show_layout(apply_filters('jack_well_filter_menu_mobile_layout', $jack_well_menu_mobile));
		}

		// Search field
		if (false) {
		do_action('jack_well_action_search', 'normal', 'search_mobile', false);
		}

		// Social icons
		jack_well_show_layout(jack_well_get_socials_links(), '<div class="socials_mobile">', '</div>');
		?>
	</div>
</div>
