<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap<?php
				if (!jack_well_is_inherit(jack_well_get_theme_option('copyright_scheme')))
					echo ' scheme_' . esc_attr(jack_well_get_theme_option('copyright_scheme'));
 				?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				$jack_well_copyright = jack_well_get_theme_option('copyright');
				if (!empty($jack_well_copyright)) {
					// Replace {{Y}} or {Y} with the current year
					$jack_well_copyright = str_replace(array('{{Y}}', '{Y}'), date('Y'), $jack_well_copyright);
					// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
					$jack_well_copyright = jack_well_prepare_macros($jack_well_copyright);
					// Display copyright
					echo wp_kses_data(nl2br($jack_well_copyright));
				}
			?></div>
		</div>
	</div>
</div>
