<?php
/* Give support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('jack_well_give_theme_setup9')) {
    add_action( 'after_setup_theme', 'jack_well_give_theme_setup9', 9 );
    function jack_well_give_theme_setup9() {
        if (jack_well_exists_give()) {
            add_filter( 'give_form_grid_image_size', 'jack_well_give_size');
        }
		
		add_filter( 'jack_well_filter_merge_styles',						'jack_well_give_merge_styles');
		
		
        if (is_admin()) {
            add_filter( 'jack_well_filter_tgmpa_required_plugins',		'jack_well_give_tgmpa_required_plugins' );
        }
    }
}
if ( !function_exists( 'jack_well_give_size' ) ) {
    function jack_well_give_size()    {
        $image_size = jack_well_get_thumb_size('huge');
        return $image_size;
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'jack_well_give_tgmpa_required_plugins' ) ) {
    function jack_well_give_tgmpa_required_plugins($list=array()) {
        if (jack_well_storage_isset('required_plugins', 'give')) {
            $list[] = array(
                'name' 		=> jack_well_storage_get_array('required_plugins', 'give'),
                'slug' 		=> 'give',
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if plugin installed and activated
if ( !function_exists( 'jack_well_exists_give' ) ) {
    function jack_well_exists_give() {
        return function_exists('Give');
    }
}

// Custom styles and scripts
//------------------------------------------------------------------------
	
// Merge custom styles
if ( !function_exists( 'jack_well_give_merge_styles' ) ) {
	//Handler of the add_filter( 'jack_well_filter_merge_styles', 'jack_well_give_merge_styles');
	function jack_well_give_merge_styles($list) {
		if (jack_well_exists_give()) {
			$list[] = 'plugins/give/_give.scss';
		}
		return $list;
	}
}

// Add plugin-specific colors and fonts to the custom CSS
if (jack_well_exists_give()) { require_once JACK_WELL_THEME_DIR . 'plugins/give/give-styles.php'; }

?>