<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('jack_well_storage_get')) {
	function jack_well_storage_get($var_name, $default='') {
		global $JACK_WELL_STORAGE;
		return isset($JACK_WELL_STORAGE[$var_name]) ? $JACK_WELL_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('jack_well_storage_set')) {
	function jack_well_storage_set($var_name, $value) {
		global $JACK_WELL_STORAGE;
		$JACK_WELL_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('jack_well_storage_empty')) {
	function jack_well_storage_empty($var_name, $key='', $key2='') {
		global $JACK_WELL_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($JACK_WELL_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($JACK_WELL_STORAGE[$var_name][$key]);
		else
			return empty($JACK_WELL_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('jack_well_storage_isset')) {
	function jack_well_storage_isset($var_name, $key='', $key2='') {
		global $JACK_WELL_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($JACK_WELL_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($JACK_WELL_STORAGE[$var_name][$key]);
		else
			return isset($JACK_WELL_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('jack_well_storage_inc')) {
	function jack_well_storage_inc($var_name, $value=1) {
		global $JACK_WELL_STORAGE;
		if (empty($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = 0;
		$JACK_WELL_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('jack_well_storage_concat')) {
	function jack_well_storage_concat($var_name, $value) {
		global $JACK_WELL_STORAGE;
		if (empty($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = '';
		$JACK_WELL_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('jack_well_storage_get_array')) {
	function jack_well_storage_get_array($var_name, $key, $key2='', $default='') {
		global $JACK_WELL_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($JACK_WELL_STORAGE[$var_name][$key]) ? $JACK_WELL_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($JACK_WELL_STORAGE[$var_name][$key][$key2]) ? $JACK_WELL_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('jack_well_storage_set_array')) {
	function jack_well_storage_set_array($var_name, $key, $value) {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if ($key==='')
			$JACK_WELL_STORAGE[$var_name][] = $value;
		else
			$JACK_WELL_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('jack_well_storage_set_array2')) {
	function jack_well_storage_set_array2($var_name, $key, $key2, $value) {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if (!isset($JACK_WELL_STORAGE[$var_name][$key])) $JACK_WELL_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$JACK_WELL_STORAGE[$var_name][$key][] = $value;
		else
			$JACK_WELL_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('jack_well_storage_merge_array')) {
	function jack_well_storage_merge_array($var_name, $key, $value) {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if ($key==='')
			$JACK_WELL_STORAGE[$var_name] = array_merge($JACK_WELL_STORAGE[$var_name], $value);
		else
			$JACK_WELL_STORAGE[$var_name][$key] = array_merge($JACK_WELL_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('jack_well_storage_set_array_after')) {
	function jack_well_storage_set_array_after($var_name, $after, $key, $value='') {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if (is_array($key))
			jack_well_array_insert_after($JACK_WELL_STORAGE[$var_name], $after, $key);
		else
			jack_well_array_insert_after($JACK_WELL_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('jack_well_storage_set_array_before')) {
	function jack_well_storage_set_array_before($var_name, $before, $key, $value='') {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if (is_array($key))
			jack_well_array_insert_before($JACK_WELL_STORAGE[$var_name], $before, $key);
		else
			jack_well_array_insert_before($JACK_WELL_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('jack_well_storage_push_array')) {
	function jack_well_storage_push_array($var_name, $key, $value) {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($JACK_WELL_STORAGE[$var_name], $value);
		else {
			if (!isset($JACK_WELL_STORAGE[$var_name][$key])) $JACK_WELL_STORAGE[$var_name][$key] = array();
			array_push($JACK_WELL_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('jack_well_storage_pop_array')) {
	function jack_well_storage_pop_array($var_name, $key='', $defa='') {
		global $JACK_WELL_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($JACK_WELL_STORAGE[$var_name]) && is_array($JACK_WELL_STORAGE[$var_name]) && count($JACK_WELL_STORAGE[$var_name]) > 0) 
				$rez = array_pop($JACK_WELL_STORAGE[$var_name]);
		} else {
			if (isset($JACK_WELL_STORAGE[$var_name][$key]) && is_array($JACK_WELL_STORAGE[$var_name][$key]) && count($JACK_WELL_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($JACK_WELL_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('jack_well_storage_inc_array')) {
	function jack_well_storage_inc_array($var_name, $key, $value=1) {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if (empty($JACK_WELL_STORAGE[$var_name][$key])) $JACK_WELL_STORAGE[$var_name][$key] = 0;
		$JACK_WELL_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('jack_well_storage_concat_array')) {
	function jack_well_storage_concat_array($var_name, $key, $value) {
		global $JACK_WELL_STORAGE;
		if (!isset($JACK_WELL_STORAGE[$var_name])) $JACK_WELL_STORAGE[$var_name] = array();
		if (empty($JACK_WELL_STORAGE[$var_name][$key])) $JACK_WELL_STORAGE[$var_name][$key] = '';
		$JACK_WELL_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('jack_well_storage_call_obj_method')) {
	function jack_well_storage_call_obj_method($var_name, $method, $param=null) {
		global $JACK_WELL_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($JACK_WELL_STORAGE[$var_name]) ? $JACK_WELL_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($JACK_WELL_STORAGE[$var_name]) ? $JACK_WELL_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('jack_well_storage_get_obj_property')) {
	function jack_well_storage_get_obj_property($var_name, $prop, $default='') {
		global $JACK_WELL_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($JACK_WELL_STORAGE[$var_name]->$prop) ? $JACK_WELL_STORAGE[$var_name]->$prop : $default;
	}
}
?>