<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_seo = jack_well_is_on(jack_well_get_theme_option('seo_snippets'));
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post_item_single post_type_'.esc_attr(get_post_type()) 
												. ' post_format_'.esc_attr(str_replace('post-format-', '', get_post_format())) 
												);
		if ($jack_well_seo) {
			?> itemscope="itemscope" 
			   itemprop="articleBody" 
			   itemtype="http://schema.org/<?php echo esc_attr(jack_well_get_markup_schema()); ?>" 
			   itemid="<?php echo esc_url(get_the_permalink()); ?>"
			   content="<?php echo esc_attr(get_the_title()); ?>"<?php
		}
?>><?php

	do_action('jack_well_action_before_post_data'); 

	// Structured data snippets
	if ($jack_well_seo)
		get_template_part('templates/seo');



	// Featured image
	if ( jack_well_is_off(jack_well_get_theme_option('hide_featured_on_single'))
			&& !jack_well_sc_layouts_showed('featured') 
			&& strpos(get_the_content(), '[trx_widget_banner]')===false) {
		do_action('jack_well_action_before_post_featured');
		$tags = get_the_tag_list( '<span class="post_meta_item post_tags"><span class="post_meta_label">'.'</span> ', ' ', '</span>' );
		jack_well_show_post_featured(
			array(
				'post_info' => !empty($tags) ? '<div class="post_info"><div class="post_tags">'.$tags.'</div></div>' : ''
			)
		);
		do_action('jack_well_action_after_post_featured'); 
	} else if (has_post_thumbnail()) {
		?><meta itemprop="image" itemtype="http://schema.org/ImageObject" content="<?php echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>"><?php
	}

	// Title and post meta
	if ( (!jack_well_sc_layouts_showed('title') || !jack_well_sc_layouts_showed('postmeta')) && !in_array(get_post_format(), array('link', 'aside', 'status', 'quote')) ) {
		do_action('jack_well_action_before_post_title'); 
		?>
		<div class="post_header entry-header">
			<?php
			if (!jack_well_sc_layouts_showed('postmeta') && jack_well_is_on(jack_well_get_theme_option('show_post_meta'))) {
				jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
						'components' => jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts')),
						'counters' => jack_well_array_get_keys_by_value(jack_well_get_theme_option('counters')),
						'seo' => jack_well_is_on(jack_well_get_theme_option('seo_snippets'))
					), 'single', 1)
				);
			}

			// Post title
			if ((!jack_well_sc_layouts_showed('title')) && (!has_post_thumbnail())) {
				the_title( '<h3 class="post_title entry-title"'.($jack_well_seo ? ' itemprop="headline"' : '').'>', '</h3>' );
			}
			// Post meta

			?>
		</div><!-- .post_header -->
		<?php
		do_action('jack_well_action_after_post_title'); 
	}

	do_action('jack_well_action_before_post_content'); 

	// Post content
	?>
	<div class="post_content entry-content" itemprop="mainEntityOfPage">
		<?php
		the_content( );

		do_action('jack_well_action_before_post_pagination');

		wp_link_pages( array(
			'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'jack-well' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'jack-well' ) . ' </span>%',
			'separator'   => '<span class="screen-reader-text">, </span>',
		) );

		// Taxonomies and share
		if ( is_single() && !is_attachment() ) {
			
			do_action('jack_well_action_before_post_meta');

				if(strpos(jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts')), 'author') == true) {

				// Post author
				$author_id = get_the_author_meta('ID');
				if (empty($author_id) && !empty($GLOBALS['post']->post_author))
					$author_id = $GLOBALS['post']->post_author;
				if ($author_id > 0) {
					$author_link = get_author_posts_url($author_id);
					$author_name = get_the_author_meta('display_name', $author_id);
					}
				}

				// Share
				$soc ='';
				if (function_exists('trx_addons_get_share_links')) {
					$soc = trx_addons_get_share_links(array(
						'type' => 'block',
						'caption' => '',
						'before' => '<span class="post_meta_item post_share">',
						'after' => '</span>',
						'echo' => false
					));
				}


			if(!empty($author_name) || ( jack_well_is_on(jack_well_get_theme_option('show_share_links') && !empty($soc)) ) ) { ?>

				<div class="post_meta post_meta_single"><?php
				?>
				<a class="post_meta_item post_author" rel="author" href="<?php echo esc_url($author_link); ?>">
					<?php esc_html_e('by ', 'jack-well') ?>
					<?php echo esc_html($author_name); ?>
				</a>
				<?php


				// Share
				if (jack_well_is_on(jack_well_get_theme_option('show_share_links')) && !empty($soc)) {
					jack_well_show_layout($soc);
				}

				?></div><?php

			}

			do_action('jack_well_action_after_post_meta'); 
		}
		?>
	</div><!-- .entry-content -->
	

	<?php
	do_action('jack_well_action_after_post_content'); 

	// Author bio.
	if ( jack_well_get_theme_option('show_author_info')==1 && is_single() && !is_attachment() && get_the_author_meta( 'description' ) ) {	// && is_multi_author()
		do_action('jack_well_action_before_post_author'); 
		get_template_part( 'templates/author-bio' );
		do_action('jack_well_action_after_post_author'); 
	}

	do_action('jack_well_action_after_post_data'); 
	?>
</article>
