<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);
$jack_well_animation = jack_well_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($jack_well_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($jack_well_post_format) ); ?>
	<?php echo (!jack_well_is_off($jack_well_animation) ? ' data-animation="'.esc_attr(jack_well_get_animation_classes($jack_well_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	jack_well_show_post_featured(array(
		'thumb_size' => jack_well_get_thumb_size($jack_well_columns==1 ? 'big' : ($jack_well_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($jack_well_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(), 'sticky', $jack_well_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>