<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_blog_style = explode('_', jack_well_get_theme_option('blog_style'));
$jack_well_columns = empty($jack_well_blog_style[1]) ? 2 : max(2, $jack_well_blog_style[1]);
$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);
$jack_well_animation = jack_well_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($jack_well_columns).' post_format_'.esc_attr($jack_well_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!jack_well_is_off($jack_well_animation) ? ' data-animation="'.esc_attr(jack_well_get_animation_classes($jack_well_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$jack_well_image_hover = jack_well_get_theme_option('image_hover');
	// Featured image
	jack_well_show_post_featured(array(
		'thumb_size' => jack_well_get_thumb_size(strpos(jack_well_get_theme_option('body_style'), 'full')!==false || $jack_well_columns < 3 
								? 'masonry-big' 
								: 'masonry-big'),
		'show_no_image' => true,
		'class' => $jack_well_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $jack_well_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>