<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_blog_style = explode('_', jack_well_get_theme_option('blog_style'));
$jack_well_columns = empty($jack_well_blog_style[1]) ? 2 : max(2, $jack_well_blog_style[1]);
$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);
$jack_well_animation = jack_well_get_theme_option('blog_animation');
$jack_well_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($jack_well_columns).' post_format_'.esc_attr($jack_well_post_format) ); ?>
	<?php echo (!jack_well_is_off($jack_well_animation) ? ' data-animation="'.esc_attr(jack_well_get_animation_classes($jack_well_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($jack_well_image[1]) && !empty($jack_well_image[2])) echo intval($jack_well_image[1]) .'x' . intval($jack_well_image[2]); ?>"
	data-src="<?php if (!empty($jack_well_image[0])) echo esc_url($jack_well_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$jack_well_image_hover = 'icon';
	if (in_array($jack_well_image_hover, array('icons', 'zoom'))) $jack_well_image_hover = 'dots';
	$jack_well_components = jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts'));
	$jack_well_counters = jack_well_array_get_keys_by_value(jack_well_get_theme_option('counters'));
	jack_well_show_post_featured(array(
		'hover' => $jack_well_image_hover,
		'thumb_size' => jack_well_get_thumb_size( strpos(jack_well_get_theme_option('body_style'), 'full')!==false || $jack_well_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($jack_well_components)
										? jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
											'components' => $jack_well_components,
											'counters' => $jack_well_counters,
											'seo' => false,
											'echo' => false
											), $jack_well_blog_style[0], $jack_well_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'jack-well') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>